export interface Pagination {
    page?: number;
    limit?: number;
    paranoid?: boolean;
    sort?: {
        field: string;
        by: 'ASC' | 'DESC';
    }[];
    search?: {
        field: string;
        value: string;
    }[];
    filter?: {
        field: string;
        operation: string;
        value: string | string[];
    }[];
    relations?: string[];
}
type Join<K, P> = K extends string ? P extends string ? `${K}${'' extends P ? '' : '.'}${P | `(${P}` | `${P})`}` : never : never;
type Prev = [never, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ...0[]];
type UnwrapPromise<T> = T extends Promise<infer U> ? UnwrapPromise<U> : T;
type UnwrapArray<T> = T extends Array<infer U> ? UnwrapArray<U> : T;
export type Column<T, D extends number = 2> = [D] extends [never] ? never : T extends Record<string, any> ? {
    [K in keyof T]-?: K extends string ? T[K] extends Date ? `${K}` : T[K] extends Array<infer U> ? `${K}` | Join<K, Column<UnwrapArray<U>, Prev[D]>> : T[K] extends Promise<infer U> ? U extends Array<infer V> ? `${K}` | Join<K, Column<UnwrapArray<V>, Prev[D]>> : `${K}` | Join<K, Column<UnwrapPromise<U>, Prev[D]>> : `${K}` | Join<K, Column<T[K], Prev[D]>> : never;
}[keyof T] : '';
export type RelationColumn<T> = Extract<Column<T>, {
    [K in Column<T>]: K extends `${infer R}.${string}` ? R : never;
}[Column<T>]>;
export {};
