"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetPagination = void 0;
const common_1 = require("@nestjs/common");
exports.GetPagination = (0, common_1.createParamDecorator)((data, ctx) => {
    const req = ctx.switchToHttp().getRequest();
    const paginationParams = {
        page: 0,
        limit: 20,
        sort: [],
        search: [],
        relations: [],
        filter: [],
        paranoid: true,
    };
    paginationParams.page = req.query.page
        ? parseInt(req.query.page.toString())
        : 0;
    paginationParams.limit = req.query.limit
        ? parseInt(req.query.limit.toString()) < 20
            ? parseInt(req.query.limit.toString())
            : 20
        : 10;
    if (req.query.sort) {
        const sortArray = req.query.sort.toString().split(',');
        paginationParams.sort = sortArray.map((sortItem) => {
            const sortBy = sortItem.split(':');
            switch (sortBy[1]) {
                case 'ASC':
                    return {
                        field: sortBy[0],
                        by: 'ASC',
                    };
                case 'DESC':
                    return {
                        field: sortBy[0],
                        by: 'DESC',
                    };
                default:
                    return {
                        field: sortBy[0],
                        by: 'DESC',
                    };
            }
        });
    }
    if (req.query.search) {
        const searchArray = req.query.search.toString().split(',');
        paginationParams.search = searchArray.map((searchItem) => {
            const field = searchItem.split(':')[0];
            const value = searchItem.split(':')[1];
            return {
                field,
                value,
            };
        });
    }
    if (req.query.relations) {
        const searchArray = req.query.relations.toString().split(',');
        paginationParams.relations = searchArray.filter((value) => value != '');
    }
    if (req.query.paranoid) {
        paginationParams.paranoid = req.query.paranoid == 'false' ? false : true;
    }
    if (req.query.filter) {
        const searchArray = req.query.filter.toString().split('|');
        paginationParams.filter = searchArray
            .map((searchItem) => {
            const data = searchItem.split(':');
            if (data[2] != '' && data[2] != '[]') {
                return {
                    field: data[0],
                    operation: data[1],
                    value: data[1] == 'in' || data[1] == 'between'
                        ? data[2].slice(1, -1).split(',')
                        : data[2],
                };
            }
        })
            .filter((x) => x != undefined);
    }
    return data && data != '' ? paginationParams[data] : paginationParams;
});
//# sourceMappingURL=get-pagination.decorator.js.map