"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Shop = void 0;
const sequelize_typescript_1 = require("sequelize-typescript");
const shop_user_entity_1 = require("./shop.user.entity");
const user_entity_1 = require("../../users/entity/user.entity");
const role_entity_1 = require("../../users/entity/role.entity");
let Shop = class Shop extends sequelize_typescript_1.Model {
};
exports.Shop = Shop;
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.BIGINT,
        allowNull: false,
        autoIncrement: true,
        unique: true,
        primaryKey: true,
    }),
    __metadata("design:type", Number)
], Shop.prototype, "id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "name", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        allowNull: true,
    }),
    __metadata("design:type", String)
], Shop.prototype, "image", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        unique: true,
        allowNull: true,
    }),
    __metadata("design:type", String)
], Shop.prototype, "email", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        unique: true,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "phone", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        unique: true,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "api_id", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "rc", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "fic", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "address", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.STRING,
        unique: true,
        allowNull: false,
    }),
    __metadata("design:type", String)
], Shop.prototype, "api_token", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.DOUBLE,
        allowNull: true,
    }),
    __metadata("design:type", Number)
], Shop.prototype, "price_invoice", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.ENUM,
        values: ['api.yalidine.com', 'api.guepex.app'],
        defaultValue: 'api.guepex.app',
    }),
    __metadata("design:type", String)
], Shop.prototype, "type_yalidine", void 0);
__decorate([
    (0, sequelize_typescript_1.HasMany)(() => shop_user_entity_1.ShopUser, {
        onDelete: 'CASCADE',
        hooks: true,
    }),
    __metadata("design:type", Array)
], Shop.prototype, "shop_user", void 0);
__decorate([
    (0, sequelize_typescript_1.BelongsToMany)(() => user_entity_1.User, () => shop_user_entity_1.ShopUser),
    __metadata("design:type", Array)
], Shop.prototype, "user", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.DATE,
        allowNull: true,
    }),
    __metadata("design:type", Date)
], Shop.prototype, "createdAt", void 0);
__decorate([
    (0, sequelize_typescript_1.Column)({
        type: sequelize_typescript_1.DataType.DATE,
        allowNull: true,
    }),
    __metadata("design:type", Date)
], Shop.prototype, "updatedAt", void 0);
exports.Shop = Shop = __decorate([
    (0, sequelize_typescript_1.Table)({
        tableName: 'shop',
        modelName: 'shop',
        timestamps: true,
        createdAt: false,
        updatedAt: false,
        deletedAt: true,
        paranoid: true,
        defaultScope: {
            attributes: {
                exclude: ['password'],
            },
        },
        scopes: {
            user(where) {
                return {
                    include: [
                        {
                            model: user_entity_1.User,
                            as: 'user',
                            attributes: [
                                'id',
                                'first_name',
                                'last_name',
                                'phone',
                                'email',
                                'key_filter',
                                'active_month',
                            ],
                            include: [
                                {
                                    model: role_entity_1.Role,
                                    as: 'role',
                                },
                            ],
                            where: where,
                        },
                    ],
                };
            },
        },
        indexes: [
            {
                fields: ['phone'],
            },
        ],
    })
], Shop);
//# sourceMappingURL=shop.entity.js.map