import { HttpService } from '@nestjs/axios';
import { Shop } from '../shop/entity/shop.entity';
import { Pagination } from 'src/util/pagination';
import { ParcelDto, ParcelDtoUpdate } from './dto/parcel.dto';
export declare class ParcelService {
    private readonly shopRepository;
    private readonly httpService;
    constructor(shopRepository: typeof Shop, httpService: HttpService);
    findAllParcel(id: string, pagination: Pagination): Promise<any>;
    readParcel(id: string, id_tracking: string): Promise<any>;
    readParcelPrint(id: string, id_tracking: string): Promise<any>;
    createParcel(id: string, dataSend: ParcelDto[] | ParcelDto): Promise<any>;
    updateParcel(id: string, traking_id: string, dataSend: ParcelDtoUpdate): Promise<any>;
    removeParcel(id: string, id_tracking: string): Promise<any>;
    findHistorique(id: string, id_tracking: string, pagination: Pagination): Promise<any>;
    findCenters(id: string, pagination: Pagination): Promise<any>;
    findWilaya(id: string, pagination: Pagination): Promise<any>;
    findCommunes(id: string, pagination: Pagination): Promise<any>;
    getFees(id: string, pagination: Pagination): Promise<any>;
    normalizeValue(value: string | string[]): string;
}
