import { ParcelService } from './parcel.service';
import { Pagination } from 'src/util/pagination';
import { ParcelDto, ParcelDtoUpdate } from './dto/parcel.dto';
import { Cache } from '@nestjs/cache-manager';
export declare class ParcelController {
    private readonly parcelService;
    constructor(parcelService: ParcelService);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
    readData(id: string, id_traking: string): Promise<any>;
    create(id: string, data: ParcelDto[] | ParcelDto): Promise<any>;
    update(id: string, traking_id: string, data: ParcelDtoUpdate): Promise<any>;
    remove(id: string, idTracking: string): Promise<any>;
}
export declare class TimelineParcelController {
    private readonly parcelService;
    constructor(parcelService: ParcelService);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
}
export declare class WilayaParcelController {
    private readonly parcelService;
    private cacheManager;
    constructor(parcelService: ParcelService, cacheManager: Cache);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
}
export declare class CommunesParcelController {
    private readonly parcelService;
    private cacheManager;
    constructor(parcelService: ParcelService, cacheManager: Cache);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
}
export declare class CenterParcelController {
    private readonly parcelService;
    private cacheManager;
    constructor(parcelService: ParcelService, cacheManager: Cache);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
}
export declare class FeeParcelController {
    private readonly parcelService;
    constructor(parcelService: ParcelService);
    getData(id: string, paginateQuery: Pagination): Promise<any>;
}
export declare class PrintParcelController {
    private readonly parcelService;
    constructor(parcelService: ParcelService);
    readData(id: string, idTracking: string): Promise<any>;
}
