"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllExceptionsFilter = void 0;
const common_1 = require("@nestjs/common");
const sequelize_1 = require("sequelize");
let AllExceptionsFilter = class AllExceptionsFilter {
    catch(exception, host) {
        const ctx = host.switchToHttp();
        const response = ctx.getResponse();
        const request = ctx.getRequest();
        const { status, message } = GetMessage(exception, request.method);
        response.status(status).json({
            statusCode: status,
            message: message,
            path: request.url,
        });
    }
};
exports.AllExceptionsFilter = AllExceptionsFilter;
exports.AllExceptionsFilter = AllExceptionsFilter = __decorate([
    (0, common_1.Catch)()
], AllExceptionsFilter);
const GetMessage = (exception, method) => {
    const GlobaleException = exception;
    if (GlobaleException.name == 'TokenExpiredError') {
        return {
            message: GlobaleException.message,
            status: 401,
        };
    }
    if (GlobaleException.name == 'BadRequestException') {
        return {
            message: GlobaleException.message || GlobaleException.getResponse()['message'],
            status: StatusCode(method, GlobaleException.getStatus()),
        };
    }
    if (exception instanceof sequelize_1.Error) {
        const returnData = exception;
        return {
            message: returnData.message,
            status: StatusCode(method),
        };
    }
    return {
        status: StatusCode(method),
        message: typeof exception == 'string'
            ? exception
            : exception.message,
    };
};
const StatusCode = (method, statue) => {
    let state = statue ? statue : 400;
    switch (method) {
        case 'PATCH':
            state = 422;
            break;
        case 'POST':
            state = 400;
            break;
        case 'DELETE':
            state = 422;
            break;
        default:
            break;
    }
    return state;
};
//# sourceMappingURL=exception.filter.js.map