"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.databaseProviders = void 0;
const sequelize_typescript_1 = require("sequelize-typescript");
const constants_1 = require("../constants");
const database_config_1 = require("./database.config");
const sequelize_hooks_1 = require("./sequelize.hooks");
const user_hook_1 = require("../../modules/users/hook/user.hook");
const role_entity_1 = require("../../modules/users/entity/role.entity");
const user_entity_1 = require("../../modules/users/entity/user.entity");
const user_role_entity_1 = require("../../modules/users/entity/user.role.entity");
const shop_entity_1 = require("../../modules/shop/entity/shop.entity");
const shop_user_entity_1 = require("../../modules/shop/entity/shop.user.entity");
exports.databaseProviders = [
    {
        provide: constants_1.SEQUELIZE,
        useFactory: async () => {
            let config;
            switch (process.env.NODE_ENV) {
                case constants_1.DEVELOPMENT:
                    config = database_config_1.databaseConfig.development;
                    break;
                case constants_1.TEST:
                    config = database_config_1.databaseConfig.test;
                    break;
                case constants_1.PRODUCTION:
                    config = database_config_1.databaseConfig.production;
                    break;
                default:
                    config = database_config_1.databaseConfig.development;
            }
            const sequelize = new sequelize_typescript_1.Sequelize(config);
            sequelize.addModels([role_entity_1.Role, user_entity_1.User, shop_entity_1.Shop, user_role_entity_1.UserRole, shop_user_entity_1.ShopUser]);
            await sequelize.sync({});
            (0, user_hook_1.setupUserHooks)(sequelize);
            (0, sequelize_hooks_1.setupSequelizeHooks)(sequelize);
            return sequelize;
        },
    },
];
//# sourceMappingURL=database.providers.js.map