"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleGuard = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const public_decorator_1 = require("../decorators/public.decorator");
const users_service_1 = require("../../modules/users/users.service");
let RoleGuard = class RoleGuard {
    constructor(reflector, userService) {
        this.reflector = reflector;
        this.userService = userService;
    }
    async matchRoles(roles, userRole) {
        let ckeck = false;
        userRole.map((rol) => {
            roles.forEach((ele) => {
                if (ele == rol) {
                    ckeck = true;
                    return;
                }
            });
        });
        return ckeck;
    }
    async canActivate(context) {
        if (process.env.ACTIVE_AUTH === 'true') {
            return true;
        }
        else {
            const isPublic = this.reflector.getAllAndOverride(public_decorator_1.IS_PUBLIC_KEY, [context.getHandler(), context.getClass()]);
            if (isPublic == true) {
                return true;
            }
            else {
            }
            let roles = this.reflector.get('RolesUse', context.getClass());
            if (this.reflector.get('RolesUse', context.getHandler())) {
                roles = this.reflector.get('RolesUse', context.getHandler());
            }
            if (!roles) {
                return true;
            }
            if (roles) {
                const request = context.switchToHttp().getRequest();
                const user = request.user;
                const check = await this.userService.CheckValid(user.id);
                if (check) {
                    return await this.matchRoles(roles, user.role);
                }
                else {
                    throw new common_1.NotAcceptableException();
                }
            }
            else {
                throw new common_1.NotAcceptableException();
            }
        }
    }
};
exports.RoleGuard = RoleGuard;
exports.RoleGuard = RoleGuard = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector,
        users_service_1.UsersService])
], RoleGuard);
//# sourceMappingURL=role.guard.js.map