"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminAuthController = void 0;
const common_1 = require("@nestjs/common");
const public_decorator_1 = require("./decorators/public.decorator");
const auth_dto_1 = require("./dto/auth.dto");
const user_decorator_1 = require("./decorators/user.decorator");
const auth_service_1 = require("./auth.service");
const user_dto_1 = require("../modules/users/dto/user.dto");
let AdminAuthController = class AdminAuthController {
    constructor(authService) {
        this.authService = authService;
    }
    signIn(signInDto) {
        return this.authService.authenticateAdmin({
            username: signInDto.username,
            password: signInDto.password,
        });
    }
    profil(id) {
        return this.authService.getProfile(id);
    }
    profilUpdate(id, data) {
        return this.authService.updateProfile(id, data);
    }
    changePassword(id, data) {
        return this.authService.ChangePassword(id, data);
    }
};
exports.AdminAuthController = AdminAuthController;
__decorate([
    (0, public_decorator_1.Public)(),
    (0, common_1.Post)('SignIn'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", void 0)
], AdminAuthController.prototype, "signIn", null);
__decorate([
    (0, common_1.Get)('profile'),
    __param(0, (0, user_decorator_1.User)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], AdminAuthController.prototype, "profil", null);
__decorate([
    (0, common_1.HttpCode)(204),
    (0, common_1.Patch)('profile'),
    __param(0, (0, user_decorator_1.User)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, user_dto_1.UserDtoUpdate]),
    __metadata("design:returntype", void 0)
], AdminAuthController.prototype, "profilUpdate", null);
__decorate([
    (0, common_1.HttpCode)(204),
    (0, common_1.Patch)('password-change'),
    __param(0, (0, user_decorator_1.User)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, user_dto_1.ChangePassword]),
    __metadata("design:returntype", void 0)
], AdminAuthController.prototype, "changePassword", null);
exports.AdminAuthController = AdminAuthController = __decorate([
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService])
], AdminAuthController);
//# sourceMappingURL=auth.controller.js.map