"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const parcel_module_1 = require("./modules/Parcel/parcel.module");
const common_1 = require("@nestjs/common");
const database_module_1 = require("./core/database/database.module");
const config_1 = require("@nestjs/config");
const users_module_1 = require("./modules/users/users.module");
const core_1 = require("@nestjs/core");
const auth_module_1 = require("./auth/auth.module");
const accessToken_guard_1 = require("./auth/guards/accessToken.guard");
const jwt_1 = require("@nestjs/jwt");
const path_1 = require("path");
const serve_static_1 = require("@nestjs/serve-static");
const upload_controller_1 = require("./upload.controller");
const shop_module_1 = require("./modules/shop/shop.module");
const cache_manager_1 = require("@nestjs/cache-manager");
const proxy_controller_1 = require("./proxy.controller");
const proxy_service_1 = require("./proxy.service");
const role_guard_1 = require("./auth/guards/role.guard");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            cache_manager_1.CacheModule.register({
                isGlobal: true,
            }),
            jwt_1.JwtModule.register({
                global: true,
            }),
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(__dirname, '..', 'public'),
                serveRoot: '/public',
            }),
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            database_module_1.DatabaseModule,
            users_module_1.UsersModule,
            auth_module_1.AuthModule,
            shop_module_1.ShopsModule,
            parcel_module_1.ParcelModule,
        ],
        providers: [
            proxy_service_1.ProxyService,
            {
                provide: core_1.APP_GUARD,
                useClass: accessToken_guard_1.AccessTokenGuard,
            },
            {
                provide: core_1.APP_GUARD,
                useClass: role_guard_1.RoleGuard,
            },
        ],
        controllers: [upload_controller_1.UploadController, proxy_controller_1.ProxyController],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map