"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetPaginationQuery = GetPaginationQuery;
const sequelize_1 = require("sequelize");
const common_1 = require("@nestjs/common");
const sequelize_2 = require("sequelize");
async function GetPaginationQuery(query) {
    try {
        let { entityBuild, isSingle, id, dataFilter } = query;
        const options = {};
        if (!isSingle) {
            options.limit = dataFilter.limit;
            options.offset = dataFilter.page;
        }
        options.distinct = true;
        options.paranoid = dataFilter.paranoid;
        const globalWhere = dataFilter.filter?.filter((x) => x.field.includes(entityBuild.tableName));
        const nestedWhere = dataFilter.filter?.filter((x) => !x.field.includes(entityBuild.tableName));
        if (dataFilter.search && dataFilter.search.length) {
            options.where = {
                [sequelize_1.Op.or]: dataFilter.search.map((data) => ({
                    [`$${data.field}$`]: { [sequelize_1.Op.like]: `%${data.value}%` },
                })),
            };
        }
        if (globalWhere && globalWhere.length) {
            options.where = {
                ...options.where,
                [sequelize_1.Op.and]: globalWhere.map((data) => ({
                    [`$${data.field}$`]: GetOperation(data),
                })),
            };
        }
        if (dataFilter.relations && dataFilter.relations.length) {
            const ScopeInclude = [];
            dataFilter.relations.map((relation) => {
                const where = nestedWhere?.filter((x) => x.field.includes(relation));
                ScopeInclude.push({
                    method: where?.length
                        ? [
                            relation,
                            {
                                [sequelize_1.Op.and]: where.map((data) => ({
                                    [`${data.field.split('.')[1]}`]: GetOperation(data),
                                })),
                            },
                        ]
                        : [relation],
                });
            });
            entityBuild = entityBuild.scope(['defaultScope', ...ScopeInclude]);
        }
        if (dataFilter.sort && dataFilter.sort.length) {
            options.order = dataFilter.sort.map((x) => {
                return [sequelize_2.default.col(`${x.field}`), x.by];
            });
        }
        if (isSingle && isSingle == true && id) {
            const data = await entityBuild.findByPk(id, options);
            if (data)
                return data;
            throw new common_1.NotFoundException();
        }
        else {
            return await entityBuild.findAndCountAll(options);
        }
    }
    catch (error) {
        if (error.status) {
            throw error;
        }
        throw new common_1.BadRequestException(error);
    }
}
function GetOperation({ operation, value, }) {
    switch (operation) {
        case '>=':
            return { [sequelize_1.Op.gte]: value };
        case '>':
            return { [sequelize_1.Op.gt]: value };
        case '<=':
            return { [sequelize_1.Op.lte]: value };
        case '<':
            return { [sequelize_1.Op.lt]: value };
        case 'in':
            return { [sequelize_1.Op.in]: value };
        case '!=':
            return { [sequelize_1.Op.ne]: value };
        case 'notIn':
            return { [sequelize_1.Op.notIn]: value };
        case 'between':
            return { [sequelize_1.Op.between]: value };
        default:
            return { [sequelize_1.Op.eq]: value };
    }
}
//# sourceMappingURL=CorePaginationSQ.js.map