"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupUserHooks = setupUserHooks;
const user_entity_1 = require("../entity/user.entity");
const bcrypt = require("bcrypt");
function setupUserHooks(sequelize) {
    user_entity_1.User.addHook('beforeCreate', async (instance) => {
        if (instance.password && instance.password != '') {
            instance.password = await bcrypt.hash(instance.password, 10);
        }
    });
    user_entity_1.User.addHook('beforeUpdate', async (instance) => {
        if (instance.password && instance.password != '') {
            instance.password = await bcrypt.hash(instance.password, 10);
        }
    });
}
//# sourceMappingURL=user.hook.js.map