"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShopService = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("../../core/constants");
const CorePaginationSQ_1 = require("../../util/CorePaginationSQ");
const shop_user_entity_1 = require("./entity/shop.user.entity");
let ShopService = class ShopService {
    constructor(shopRepository, shopUserRepository) {
        this.shopRepository = shopRepository;
        this.shopUserRepository = shopUserRepository;
    }
    async onModuleInit() {
        const CheckShop = await this.shopRepository.count();
        if (CheckShop == 0) {
            try {
                await this.shopRepository.bulkCreate([
                    {
                        name: 'AZAR INFORMATIQUE',
                        email: 'zakariacharif1998@gmail.com',
                        phone: '+213662934692',
                        api_id: '46155502783185261942',
                        rc: '2812068538',
                        fic: '1002828601761559810',
                        address: 'ALGER / BIRKHADEM',
                        api_token: 'ecV8yExxlLFjHwaR1YygQpoeMCi64LAhaUZXv0KScf3XniJqphvV5rB2IgIdkF7O',
                        price_invoice: 8000,
                        type_yalidine: 'api.yalidine.com',
                        shop_user: [
                            {
                                id_user: 3,
                            },
                        ],
                    },
                    {
                        name: 'Anis Info 28',
                        email: 'zizosahnoune@gmail.com',
                        phone: '+213550054670',
                        api_id: '70515088762369324603',
                        rc: '28/00-2894059a23',
                        fic: '10028120017619602800',
                        address: 'berhoum msila alger',
                        api_token: 'vPRofqE1JgGcwc3WSVmoZArOUg0MTqk249L4Xz6r8IGfu1VMshtBNSXDQ6dPansC',
                        price_invoice: 8000,
                        type_yalidine: 'api.yalidine.com',
                        shop_user: [
                            {
                                id_user: 4,
                            },
                        ],
                    },
                    {
                        name: 'Pc  Informatique (divers) 28',
                        email: 'Kariminformatique123@gmail.com',
                        phone: '+213771773819',
                        api_id: '40296451150819784687',
                        rc: '28/00-2898032a25',
                        fic: '101105984',
                        address: 'BERHOUM MSILA ALGER',
                        api_token: '67XskiCjPcHSDmHptjN8aDCZ2KYeoyuWnZwY3V60BTqAf2wALrOhFQRSdl5E5KgG',
                        price_invoice: 8000,
                        type_yalidine: 'api.guepex.app',
                        shop_user: [
                            {
                                id_user: 5,
                            },
                        ],
                    },
                    {
                        name: 'Anis Info Store divers 28',
                        email: 'zizosahnoune04@gmail.com',
                        phone: '+213798939502',
                        api_id: '29493810564956148012',
                        rc: '28/00-2894059a23',
                        fic: '10028120017619602800',
                        address: 'BERHOUM MSILA ALGER',
                        api_token: 'x6DzvO2WeH8J3bSGmZ0uXfrPpIqQntyM7ENcsiAVlYRj91CBLg4ahkoFwU5dKT',
                        price_invoice: 8000,
                        type_yalidine: 'api.guepex.app',
                        shop_user: [
                            {
                                id_user: 4,
                            },
                        ],
                    },
                    {
                        name: 'Siradj Stour 19',
                        email: 'Siradjguett@gmail.com',
                        phone: '+213672308899',
                        api_id: '00214427418173331980',
                        rc: '24A5348091-19\\00',
                        fic: '100280104038001900',
                        address: 'BERHOUM MSILA ALGER',
                        api_token: 'GcXLnMWeFN9dk1SrPqj32mzsJv5ZpRVo8bEiuwQTfxytA0g6aOYUHKID4Cl7hB',
                        price_invoice: 8000,
                        type_yalidine: 'api.guepex.app',
                        shop_user: [
                            {
                                id_user: 6,
                            },
                        ],
                    },
                ], {
                    include: [
                        {
                            model: shop_user_entity_1.ShopUser,
                            as: 'shop_user',
                        },
                    ],
                });
            }
            catch (error) {
                console.log(error);
            }
        }
    }
    async find(paginateQuery) {
        return await (0, CorePaginationSQ_1.GetPaginationQuery)({
            entityBuild: this.shopRepository,
            dataFilter: paginateQuery,
            isSingle: false,
        });
    }
    async read(id, paginateQuery) {
        return await (0, CorePaginationSQ_1.GetPaginationQuery)({
            entityBuild: this.shopRepository,
            dataFilter: paginateQuery,
            isSingle: true,
            id: id,
        });
    }
    async create(data) {
        const transaction = await this.shopRepository.sequelize.transaction();
        try {
            const shop = await this.shopRepository.create(data, {
                transaction,
            });
            await transaction.commit();
            return shop;
        }
        catch (error) {
            await transaction.rollback();
            if (error.name === 'SequelizeUniqueConstraintError') {
                throw new common_1.BadRequestException('Duplicate value detected for a unique field. (Api id or Api Token or phone or email)');
            }
            else {
                throw new common_1.BadRequestException(error);
            }
        }
    }
    async update(dataUser, id, data) {
        const transaction = await this.shopRepository.sequelize.transaction();
        try {
            const shop = await this.shopRepository.update(data, {
                where: {
                    id: id,
                },
                individualHooks: true,
                transaction,
            });
            await transaction.commit();
            return shop;
        }
        catch (error) {
            await transaction.rollback();
            if (error.name === 'SequelizeUniqueConstraintError') {
                throw new common_1.BadRequestException('Duplicate value detected for a unique field. (Api id or Api Token or phone or email)');
            }
            else {
                throw new common_1.BadRequestException(error);
            }
        }
    }
    async remove(id) {
        return await this.shopRepository.destroy({
            force: true,
            where: {
                id: id,
            },
        });
    }
    async addUserToShop(id_shop, id) {
        const transaction = await this.shopUserRepository.sequelize.transaction();
        try {
            const exist = await this.shopUserRepository.findOne({
                where: {
                    id_shop: id_shop,
                    id_user: id,
                },
            });
            if (exist)
                throw new common_1.BadRequestException('This user its exist');
            const user = await this.shopUserRepository.create({
                id_shop: id_shop,
                id_user: id,
            }, {
                transaction,
            });
            await transaction.commit();
            return user;
        }
        catch (error) {
            await transaction.rollback();
            throw new common_1.BadRequestException(error);
        }
    }
    async removeUserShop(id_shop, id) {
        return await this.shopUserRepository.destroy({
            force: true,
            where: {
                id_user: id,
                id_shop: id_shop,
            },
        });
    }
};
exports.ShopService = ShopService;
exports.ShopService = ShopService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(constants_1.SHOP_REPOSITORY)),
    __param(1, (0, common_1.Inject)(constants_1.SHOP_USERS_REPOSITORY)),
    __metadata("design:paramtypes", [Object, Object])
], ShopService);
//# sourceMappingURL=shop.service.js.map