"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParcelService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const constants_1 = require("../../core/constants");
let ParcelService = class ParcelService {
    constructor(shopRepository, httpService) {
        this.shopRepository = shopRepository;
        this.httpService = httpService;
    }
    async findAllParcel(id, pagination) {
        let param = {
            page: pagination.page,
            page_size: pagination.limit,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (pagination.sort.length) {
            pagination.sort.map((x) => {
                param['order_by'] = x.field;
                param[x.by.toLocaleLowerCase()] = '';
            });
        }
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' + ShopData.type_yalidine + '/v1/parcels/', {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: param,
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return {
                count: data.total_data,
                rows: data.data,
            };
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async readParcel(id, id_tracking) {
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' +
                ShopData.type_yalidine +
                '/v1/parcels/' +
                id_tracking +
                '/?fields=order_id,from_wilaya_name,firstname,familyname,contact_phone,address,to_commune_name,to_wilaya_name,product_list,price,declared_value,is_stopdesk,stopdesk_id,freeshipping,has_exchange,do_insurance,from_wilaya_id,to_wilaya_id,to_commune_id,stopdesk_name', {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data.data[0];
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async readParcelPrint(id, id_tracking) {
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' +
                ShopData.type_yalidine +
                '/v1/parcels/?tracking=' +
                id_tracking, {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data.data;
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async createParcel(id, dataSend) {
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .post('https://' + ShopData.type_yalidine + '/v1/parcels/', dataSend.length ? dataSend : [dataSend], {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data;
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async updateParcel(id, traking_id, dataSend) {
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .patch('https://' + ShopData.type_yalidine + '/v1/parcels/' + traking_id, dataSend, {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data;
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async removeParcel(id, id_tracking) {
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (ShopData && ShopData.api_id && ShopData.api_token && id_tracking) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .delete('https://' +
                ShopData.type_yalidine +
                '/v1/parcels/?tracking=' +
                id_tracking, {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data;
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async findHistorique(id, id_tracking, pagination) {
        let param = {
            page: pagination.page,
            page_size: pagination.limit,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (pagination.sort.length) {
            pagination.sort.map((x) => {
                param['order_by'] = x.field;
                param[x.by.toLocaleLowerCase()] = '';
            });
        }
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' +
                ShopData.type_yalidine +
                '/v1/histories/' +
                id_tracking, {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: param,
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return {
                count: data.total_data,
                rows: data.data,
            };
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async findCenters(id, pagination) {
        let param = {
            page: pagination.page,
            page_size: 400,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (pagination.sort.length) {
            pagination.sort.map((x) => {
                param['order_by'] = x.field;
                param[x.by.toLocaleLowerCase()] = '';
            });
        }
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' + ShopData.type_yalidine + '/v1/centers/', {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: param,
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return {
                count: data.total_data,
                rows: data.data,
            };
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async findWilaya(id, pagination) {
        let param = {
            page: pagination.page,
            page_size: 100,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (pagination.sort.length) {
            pagination.sort.map((x) => {
                param['order_by'] = x.field;
                param[x.by.toLocaleLowerCase()] = '';
            });
        }
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' + ShopData.type_yalidine + '/v1/wilayas/', {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: param,
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return {
                count: data.total_data,
                rows: data.data,
            };
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async findCommunes(id, pagination) {
        let param = {
            page: pagination.page,
            page_size: 1000,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (pagination.sort.length) {
            pagination.sort.map((x) => {
                param['order_by'] = x.field;
                param[x.by.toLocaleLowerCase()] = '';
            });
        }
        if (ShopData && ShopData.api_id && ShopData.api_token) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' + ShopData.type_yalidine + '/v1/communes/', {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: param,
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return {
                count: data.total_data,
                rows: data.data,
            };
        }
        else {
            throw new common_1.NotFoundException('Keys Require');
        }
    }
    async getFees(id, pagination) {
        let param = {
            page: pagination.page,
            page_size: 100,
        };
        const ShopData = await this.shopRepository.findOne({
            where: {
                id: id,
            },
            attributes: ['api_id', 'api_token', 'type_yalidine'],
        });
        if (pagination.filter.length) {
            pagination.filter.map((x) => {
                param[x.field] = this.normalizeValue(x.value);
            });
        }
        if (ShopData &&
            ShopData.api_id &&
            ShopData.api_token &&
            param['from_wilaya_id'] &&
            param['to_wilaya_id']) {
            const { data } = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get('https://' +
                ShopData.type_yalidine +
                '/v1/fees/?from_wilaya_id=' +
                param['from_wilaya_id'] +
                '&to_wilaya_id=' +
                param['to_wilaya_id'], {
                headers: {
                    'X-API-ID': ShopData.api_id,
                    'X-API-TOKEN': ShopData.api_token,
                },
                params: {
                    page: pagination.page,
                    page_size: 100,
                },
            })
                .pipe((0, rxjs_1.catchError)((error) => {
                throw new common_1.BadRequestException(error.response.data['error']['message']
                    ? error.response.data['error']['message']
                    : error.message);
            })));
            return data;
        }
        else {
            return {};
        }
    }
    normalizeValue(value) {
        if (Array.isArray(value)) {
            return value.join(',');
        }
        return value;
    }
};
exports.ParcelService = ParcelService;
exports.ParcelService = ParcelService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(constants_1.SHOP_REPOSITORY)),
    __metadata("design:paramtypes", [Object, axios_1.HttpService])
], ParcelService);
//# sourceMappingURL=parcel.service.js.map