"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrintParcelController = exports.FeeParcelController = exports.CenterParcelController = exports.CommunesParcelController = exports.WilayaParcelController = exports.TimelineParcelController = exports.ParcelController = void 0;
const common_1 = require("@nestjs/common");
const parcel_service_1 = require("./parcel.service");
const get_pagination_decorator_1 = require("../../util/get-pagination.decorator");
const parcel_dto_1 = require("./dto/parcel.dto");
const roles_decorator_1 = require("../../auth/decorators/roles.decorator");
const cache_manager_1 = require("@nestjs/cache-manager");
let ParcelController = class ParcelController {
    constructor(parcelService) {
        this.parcelService = parcelService;
    }
    getData(id, paginateQuery) {
        return this.parcelService.findAllParcel(id, paginateQuery);
    }
    readData(id, id_traking) {
        return this.parcelService.readParcel(id, id_traking);
    }
    create(id, data) {
        return this.parcelService.createParcel(id, data);
    }
    update(id, traking_id, data) {
        return this.parcelService.updateParcel(id, traking_id, data);
    }
    remove(id, idTracking) {
        return this.parcelService.removeParcel(id, idTracking);
    }
};
exports.ParcelController = ParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], ParcelController.prototype, "getData", null);
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(':id_traking'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Param)('id_traking')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], ParcelController.prototype, "readData", null);
__decorate([
    (0, common_1.HttpCode)(201),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], ParcelController.prototype, "create", null);
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin', 'admin'),
    (0, common_1.HttpCode)(204),
    (0, common_1.Patch)(':traking_id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Param)('traking_id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, parcel_dto_1.ParcelDtoUpdate]),
    __metadata("design:returntype", void 0)
], ParcelController.prototype, "update", null);
__decorate([
    (0, roles_decorator_1.Roles)('superAdmin', 'admin'),
    (0, common_1.HttpCode)(204),
    (0, common_1.Delete)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('id_tracking')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], ParcelController.prototype, "remove", null);
exports.ParcelController = ParcelController = __decorate([
    (0, common_1.Controller)('parcel/:id'),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService])
], ParcelController);
let TimelineParcelController = class TimelineParcelController {
    constructor(parcelService) {
        this.parcelService = parcelService;
    }
    getData(id, paginateQuery) {
        return this.parcelService.findAllParcel(id, paginateQuery);
    }
};
exports.TimelineParcelController = TimelineParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], TimelineParcelController.prototype, "getData", null);
exports.TimelineParcelController = TimelineParcelController = __decorate([
    (0, common_1.Controller)('timeline/:id'),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService])
], TimelineParcelController);
let WilayaParcelController = class WilayaParcelController {
    constructor(parcelService, cacheManager) {
        this.parcelService = parcelService;
        this.cacheManager = cacheManager;
    }
    async getData(id, paginateQuery) {
        const value = await this.cacheManager.get('wilaya-get' + JSON.stringify(paginateQuery));
        if (value)
            return value;
        let data = await this.parcelService.findWilaya(id, paginateQuery);
        if (data) {
            await this.cacheManager.set('wilaya-get' + JSON.stringify(paginateQuery), data, 20000);
            return data;
        }
    }
};
exports.WilayaParcelController = WilayaParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], WilayaParcelController.prototype, "getData", null);
exports.WilayaParcelController = WilayaParcelController = __decorate([
    (0, common_1.Controller)('wilaya/:id'),
    __param(1, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService,
        cache_manager_1.Cache])
], WilayaParcelController);
let CommunesParcelController = class CommunesParcelController {
    constructor(parcelService, cacheManager) {
        this.parcelService = parcelService;
        this.cacheManager = cacheManager;
    }
    async getData(id, paginateQuery) {
        const value = await this.cacheManager.get('communes-get' + JSON.stringify(paginateQuery));
        if (value)
            return value;
        let data = await this.parcelService.findCommunes(id, paginateQuery);
        if (data) {
            await this.cacheManager.set('communes-get' + JSON.stringify(paginateQuery), data, 20000);
            return data;
        }
    }
};
exports.CommunesParcelController = CommunesParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], CommunesParcelController.prototype, "getData", null);
exports.CommunesParcelController = CommunesParcelController = __decorate([
    (0, common_1.Controller)('communes/:id'),
    __param(1, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService,
        cache_manager_1.Cache])
], CommunesParcelController);
let CenterParcelController = class CenterParcelController {
    constructor(parcelService, cacheManager) {
        this.parcelService = parcelService;
        this.cacheManager = cacheManager;
    }
    async getData(id, paginateQuery) {
        const value = await this.cacheManager.get('center-get' + JSON.stringify(paginateQuery));
        if (value)
            return value;
        let data = await this.parcelService.findCenters(id, paginateQuery);
        if (data) {
            await this.cacheManager.set('center-get' + JSON.stringify(paginateQuery), data, 20000);
            return data;
        }
    }
};
exports.CenterParcelController = CenterParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], CenterParcelController.prototype, "getData", null);
exports.CenterParcelController = CenterParcelController = __decorate([
    (0, common_1.Controller)('center/:id'),
    __param(1, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService,
        cache_manager_1.Cache])
], CenterParcelController);
let FeeParcelController = class FeeParcelController {
    constructor(parcelService) {
        this.parcelService = parcelService;
    }
    getData(id, paginateQuery) {
        return this.parcelService.getFees(id, paginateQuery);
    }
};
exports.FeeParcelController = FeeParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, get_pagination_decorator_1.GetPagination)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], FeeParcelController.prototype, "getData", null);
exports.FeeParcelController = FeeParcelController = __decorate([
    (0, common_1.Controller)('fee/:id'),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService])
], FeeParcelController);
let PrintParcelController = class PrintParcelController {
    constructor(parcelService) {
        this.parcelService = parcelService;
    }
    readData(id, idTracking) {
        return this.parcelService.readParcelPrint(id, idTracking);
    }
};
exports.PrintParcelController = PrintParcelController;
__decorate([
    (0, common_1.HttpCode)(200),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('id_tracking')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], PrintParcelController.prototype, "readData", null);
exports.PrintParcelController = PrintParcelController = __decorate([
    (0, common_1.Controller)('print/:id'),
    __metadata("design:paramtypes", [parcel_service_1.ParcelService])
], PrintParcelController);
//# sourceMappingURL=parcel.controller.js.map