"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupSequelizeHooks = setupSequelizeHooks;
const TimeZoneUtil_1 = require("../../util/TimeZoneUtil");
function setupSequelizeHooks(sequelize) {
    sequelize.addHook('beforeCreate', async (instance) => {
        instance.dataValues.createdAt = (0, TimeZoneUtil_1.GetDateTime)();
    });
    sequelize.addHook('beforeUpdate', async (instance) => {
        instance.dataValues.updatedAt = (0, TimeZoneUtil_1.GetDateTime)();
    });
    sequelize.addHook('beforeCount', function (options) {
        if (this._scope.include && this._scope.include.length > 0) {
            options.distinct = true;
            options.include = [];
        }
    });
}
//# sourceMappingURL=sequelize.hooks.js.map