"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessTokenGuard = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const passport_1 = require("@nestjs/passport");
const public_decorator_1 = require("../decorators/public.decorator");
const jwt_1 = require("@nestjs/jwt");
let AccessTokenGuard = class AccessTokenGuard extends (0, passport_1.AuthGuard)('jwt') {
    constructor(reflector, jwtService) {
        super();
        this.reflector = reflector;
        this.jwtService = jwtService;
    }
    async canActivate(context) {
        if (process.env.ACTIVE_AUTH === 'true') {
            return true;
        }
        else {
            const isPublic = this.reflector.getAllAndOverride(public_decorator_1.IS_PUBLIC_KEY, [context.getHandler(), context.getClass()]);
            if (isPublic) {
                return true;
            }
            else {
                const token = this.extractTokenFromHeader(context);
                if (token != '' && token != undefined) {
                    try {
                        await this.jwtService.verifyAsync(token, {
                            secret: process.env.JWTKEY,
                        });
                        return super.canActivate(context);
                    }
                    catch (error) {
                        throw new common_1.UnauthorizedException('Token Expair');
                    }
                }
                else {
                    throw new common_1.UnauthorizedException('No Token');
                }
            }
        }
    }
    extractTokenFromHeader(context) {
        const [type, token] = context.switchToHttp().getRequest().headers.authorization?.split(' ') ??
            [];
        return type === 'Bearer' ? token : undefined;
    }
};
exports.AccessTokenGuard = AccessTokenGuard;
exports.AccessTokenGuard = AccessTokenGuard = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.Reflector,
        jwt_1.JwtService])
], AccessTokenGuard);
//# sourceMappingURL=accessToken.guard.js.map