import { JwtService } from '@nestjs/jwt';
import { AuthDto } from './dto/auth.dto';
import { ConfigService } from '@nestjs/config';
import { jwtType } from 'src/types/jwtType';
import { UsersService } from 'src/modules/users/users.service';
import { ChangePassword, UserClientDto, UserDtoUpdate } from 'src/modules/users/dto/user.dto';
export declare class AuthService {
    private userService;
    private jwtService;
    private configService;
    constructor(userService: UsersService, jwtService: JwtService, configService: ConfigService);
    authenticateAdmin(authenticateDto: AuthDto): Promise<object>;
    CreateClient(dataUser: UserClientDto): Promise<object>;
    jwtServiceSing(data: jwtType): Promise<object>;
    getProfile(id: number): Promise<object>;
    updateProfile(id: number, data: UserDtoUpdate): Promise<object>;
    ChangePassword(id: number, data: ChangePassword): Promise<void>;
}
